<?php
class ControllerExtensionPaymentVolet extends Controller {
    public function index() {
        $data['action'] = $this->config->get('payment_volet_status_url');
        $data['email'] = $this->config->get('payment_volet_email');
        $data['sci_name'] = $this->config->get('payment_volet_sci_name');
        $data['order_id'] = $this->session->data['order_id'];
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        $data['amount'] = number_format($order_info['total'], 2, '.', '');
        $data['currency'] = $order_info['currency_code'];
        $data['success_url'] = $this->url->link('checkout/success');
        $data['fail_url'] = $this->url->link('checkout/failure');
        return $this->load->view('extension/payment/volet', $data);
    }

    public function confirm() {
        if ($this->session->data['payment_method']['code'] == 'volet') {
            $this->load->model('checkout/order');
            $this->model_checkout_order->addOrderHistory($this->session->data['order_id'], $this->config->get('payment_volet_order_status_id'));
        }
    }
}
