<?php
class ControllerExtensionPaymentVolet extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/payment/volet');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');
        $this->load->model('localisation/order_status');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_volet', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        // Ошибки
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        // Текстовые элементы
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('text_edit');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_sort_order'] = $this->language->get('entry_sort_order');
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        // Ссылки
        $data['action'] = $this->url->link('extension/payment/volet', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

        // Заполнение полей
        if (isset($this->request->post['payment_volet_status'])) {
            $data['payment_volet_status'] = $this->request->post['payment_volet_status'];
        } else {
            $data['payment_volet_status'] = $this->config->get('payment_volet_status');
        }

        if (isset($this->request->post['payment_volet_order_status_id'])) {
            $data['payment_volet_order_status_id'] = $this->request->post['payment_volet_order_status_id'];
        } else {
            $data['payment_volet_order_status_id'] = $this->config->get('payment_volet_order_status_id');
        }

        if (isset($this->request->post['payment_volet_sort_order'])) {
            $data['payment_volet_sort_order'] = $this->request->post['payment_volet_sort_order'];
        } else {
            $data['payment_volet_sort_order'] = $this->config->get('payment_volet_sort_order');
        }

        // Список статусов заказа
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        // Стандартные блоки opencart
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/volet', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/volet')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }
}